#include <iostream>
#include <cmath>

using namespace std;

struct Vec
{
    long long x, y;
    double ang;
    int idx;
};

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, i, najbolji, j, r, k, l;
    cin >> n;

    Vec* v = new Vec[2 * n];

    for (i = 0; i < n; i++)
    {
        cin >> v[i].x >> v[i].y;
        v[i].ang = atan2((double)v[i].y, (double)v[i].x);
        v[i].idx = i + 1;
    }
    for (i = 0; i < n; i++)
    {
        najbolji = i;
        for (j = i + 1; j < n; j++)
        {
            if (v[j].ang < v[najbolji].ang)
                najbolji = j;
        }
        Vec tmp = v[i];
        v[i] = v[najbolji];
        v[najbolji] = tmp;
    }
    for (i = 0; i < n; i++)
    {
        v[i + n] = v[i];
        v[i + n].ang += 2 * M_PI;
    }

    long long sx = 0, sy = 0;
    long long bestLen = 0;
    int bestL = 0, bestR = -1;

    l = 0;
    for (r = 0; r < 2 * n; r++)
    {
        sx += v[r].x;
        sy += v[r].y;

        while (v[r].ang - v[l].ang > M_PI)
        {
            sx -= v[l].x;
            sy -= v[l].y;
            l++;
        }

        long long len = sx * sx + sy * sy;
        if (len > bestLen)
        {
            bestLen = len;
            bestL = l;
            bestR = r;
        }
    }

    k = bestR - bestL + 1;
    cout << k << '\n';
    for (i = bestL; i <= bestR; i++)
    {
        cout << v[i].idx << ' ';
    }
    cout << '\n';

    delete[] v;
    return 0;
}